// Language dictionaries
const translations = {
    en: {
        // Language Names
        lang_english: "English",
        lang_spanish: "Español",
        lang_swedish: "Svenska",
        
        // Site Title & Navigation
        site_title: "MYTHERRA ONLINE",
        home: "Home",
        news: "News",
        downloads: "Downloads",
        rules: "Rules",
        register: "REGISTER",
        login: "LOGIN",
        search_placeholder: "Search...",
        
        // Main Menu
        main_menu: "Main Menu",
        changelog: "Changelog",
        
        // Account
        account: "Account",
        create_account: "Create Account",
        lost_account: "Lost Account",
        manage_account: "Manage Account",
        create_character: "Create Character",
        delete_character: "Delete Character",
        account_number: "Account number",
        password: "Password",
        lost_account_q: "Lost Account?",
        
        // Community
        community: "Community",
        characters: "Characters",
        online: "Online",
        highscores: "Highscores",
        last_kills: "Last Kills",
        market: "Market",
        houses: "Houses",
        guilds: "Guilds",
        forum: "Forum",
        team: "Team",
        
        // Shop
        shop: "Shop",
        buy_points: "Buy Points",
        gifts: "Gifts",
        
        // Server Status
        server_status: "Server Status",
        server_online: "Server Online",
        server_offline: "Server Offline",
        players_online: "Players Online:",
        ip: "IP:",
        
        // Footer
        all_rights_reserved: "All rights reserved.",
        mytherra_team: "MYTHERRA TEAM"
    },
    es: {
        // Language Names
        lang_english: "English",
        lang_spanish: "Español",
        lang_swedish: "Svenska",
        
        // Site Title & Navigation
        site_title: "MYTHERRA ONLINE",
        home: "Inicio",
        news: "Noticias",
        downloads: "Descargas",
        rules: "Reglas",
        register: "REGISTRARSE",
        login: "ENTRAR",
        search_placeholder: "Buscar...",
        
        // Main Menu
        main_menu: "Menú Principal",
        changelog: "Cambios",
        
        // Account
        account: "Cuenta",
        create_account: "Crear Cuenta",
        lost_account: "Cuenta Perdida",
        manage_account: "Gestionar Cuenta",
        create_character: "Crear Personaje",
        delete_character: "Eliminar Personaje",
        account_number: "Número de cuenta",
        password: "Contraseña",
        lost_account_q: "¿Perdiste tu cuenta?",
        
        // Community
        community: "Comunidad",
        characters: "Personajes",
        online: "En línea",
        highscores: "Puntuaciones",
        last_kills: "Últimas Muertes",
        market: "Mercado",
        houses: "Casas",
        guilds: "Gremios",
        forum: "Foro",
        team: "Equipo",
        
        // Shop
        shop: "Tienda",
        buy_points: "Comprar Puntos",
        gifts: "Regalos",
        
        // Server Status
        server_status: "Estado del Servidor",
        server_online: "Servidor En línea",
        server_offline: "Servidor Fuera de línea",
        players_online: "Jugadores En línea:",
        ip: "IP:",
        
        // Footer
        all_rights_reserved: "Todos los derechos reservados.",
        mytherra_team: "EQUIPO MYTHERRA"
    },
    sv: {
        // Language Names
        lang_english: "English",
        lang_spanish: "Español",
        lang_swedish: "Svenska",
        
        // Site Title & Navigation
        site_title: "MYTHERRA ONLINE",
        home: "Hem",
        news: "Nyheter",
        downloads: "Nedladdningar",
        rules: "Regler",
        register: "REGISTRERA",
        login: "LOGGA IN",
        search_placeholder: "Sök...",
        
        // Main Menu
        main_menu: "Huvudmeny",
        changelog: "Ändringslogg",
        
        // Account
        account: "Konto",
        create_account: "Skapa Konto",
        lost_account: "Förlorat Konto",
        manage_account: "Hantera Konto",
        create_character: "Skapa Karaktär",
        delete_character: "Ta Bort Karaktär",
        account_number: "Kontonummer",
        password: "Lösenord",
        lost_account_q: "Förlorat konto?",
        
        // Community
        community: "Gemenskap",
        characters: "Karaktärer",
        online: "Online",
        highscores: "Topplistor",
        last_kills: "Senaste Dödsfallen",
        market: "Marknad",
        houses: "Hus",
        guilds: "Gillen",
        forum: "Forum",
        team: "Team",
        
        // Shop
        shop: "Butik",
        buy_points: "Köp Poäng",
        gifts: "Presenter",
        
        // Server Status
        server_status: "Serverstatus",
        server_online: "Server Online",
        server_offline: "Server Offline",
        players_online: "Spelare Online:",
        ip: "IP:",
        
        // Footer
        all_rights_reserved: "Alla rättigheter förbehållna.",
        mytherra_team: "MYTHERRA TEAM"
    }
};

// Function to change language
function changeLanguage(lang) {
    // Save selected language to localStorage
    localStorage.setItem('language', lang);
    
    // Update flag in language selector
    const currentFlag = document.getElementById('current-flag');
    if (currentFlag) {
        currentFlag.src = `${window.location.origin}${templatePath}/telara/images/flags/${lang}.png`;
    }
    
    // Update all text elements with data-i18n attribute
    document.querySelectorAll('[data-i18n]').forEach(element => {
        const key = element.getAttribute('data-i18n');
        if (translations[lang] && translations[lang][key]) {
            if (element.tagName.toLowerCase() === 'input' && element.getAttribute('type') === 'text') {
                // For input elements, update placeholder
                element.placeholder = translations[lang][key];
            } else {
                // For other elements, update text content
                element.textContent = translations[lang][key];
            }
        }
    });
    
    // Close language selector dropdown
    document.querySelector('.language-selector').classList.remove('active');
}

// Initialize language on page load
document.addEventListener('DOMContentLoaded', function() {
    // Get saved language or use default (en)
    const savedLanguage = localStorage.getItem('language') || 'en';
    
    // Add click handlers for language options
    document.querySelectorAll('.language-option').forEach(option => {
        option.addEventListener('click', function(e) {
            e.preventDefault();
            const lang = this.getAttribute('data-lang');
            changeLanguage(lang);
        });
    });
    
    // Initialize with saved language
    changeLanguage(savedLanguage);
});