<?php
defined('MYAAC') or die('Direct access not allowed!');

if (!function_exists('mostPowerfulGuildsList') && !function_exists('mostPowerfulGuildsDatabase')) {
    require_once __DIR__ . '/powerful_guilds.php';
}

$topData = '';
$i = 0;
foreach(getTopPlayers(5) as $player) {
    $i++;
    $topData .= '<tr>
                <td>
                    <div class="player-rank">' . $i . '.</div>
                    <div class="player-info">
                        <a href="' . getPlayerLink($player['name'], false) . '">'.$player['name'].'</a>
                        <span class="player-level">' . $player['level'] . ' lvl</span>
                    </div>
                </td>
            </tr>';
}

// Get guild data
$guildData = '';
$guilds = mostPowerfulGuildsList();
if(count($guilds) > 0) {
	$guildCounter = 0;
	foreach($guilds as $guild) {
		$guildCounter++;
		if ($guildCounter > 3) break;

		$guildData .= '
<div class="guild-item">
            <div class="guild-emblem guild' . $guildCounter . '"></div>
            <div class="guild-info">
                <div class="guild-number">' . $guildCounter . '. ' . $guild['name'] . '</div>
                <div class="guild-kills">' . $guild['frags'] . ' kills</div>
            </div>
        </div>';
	}
} else {
	$guildData = '<div class="no-guilds">No guilds found.</div>';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php echo template_place_holder('head_start'); ?>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $template_path; ?>/css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $template_path; ?>/css/language-selector.css">
    <!-- End CSS -->

    <!-- JS Scripts -->
    <!--script src="https://code.jquery.com/jquery-3.6.0.min.js"></script-->
    <script src="<?php echo $template_path; ?>/js/main.js"></script>
    <script src="<?php echo $template_path; ?>/js/languages.js"></script>
    <script>
        let baseUrl = "<?= BASE_URL; ?>";
    </script>
    <script src="<?php echo $template_path; ?>/js/server_status.js"></script>
    <!-- End JS -->

    <?php echo template_place_holder('head_end'); ?>
</head>
<body>
    <?php echo template_place_holder('body_start'); ?>

    <!-- Header Navigation -->
    <header class="main-header" <?= admin() ? ' style="top: 32px;"' : ''; ?>>
        <div class="header-nav">
            <a href="<?= getLink('news'); ?>" class="nav-item">Home</a>
            <a href="<?= getLink('account/create'); ?>" class="nav-item">Register</a>
            <a href="<?= getLink('downloads'); ?>" class="nav-item">Download</a>
            <a href="<?= getLink('highscores'); ?>" class="nav-item">Ranking</a>
            <a href="<?= getLink('forum'); ?>" class="nav-item">Forum</a>

            <div class="social-icons">
                <a href="#" class="social-icon discord"><i class="fab fa-discord"></i></a>
                <a href="#" class="social-icon facebook"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="social-icon youtube"><i class="fab fa-youtube"></i></a>
            </div>
        </div>
    </header>

    <!-- Hero Banner -->
    <section class="hero-banner">
        <div class="server-logo">
            <h1>ServerName</h1>
        </div>
    </section>

    <!-- Main Content -->
    <main class="main-content">
        <div class="content-wrapper">
            <!-- Left Column -->
            <div class="left-column">
                <div class="panel">
                    <div class="panel-header">CREATE ACCOUNT</div>
                    <div class="panel-body">
                        <a href="<?= getLink('account/create'); ?>" class="create-account-btn">Create New Account</a>
                    </div>
                </div>

                <div class="panel">
                    <div class="panel-header">NEWS</div>
                    <div class="panel-body">
                        <div class="news-sections">
                            <a href="<?= getLink('news'); ?>" class="news-tab">Latest news</a>
                            <a href="<?= getLink('news/archive'); ?>" class="news-tab">News Archive</a>
                        </div>
                    </div>
                </div>

                <div class="panel">
                    <div class="panel-header">ACCOUNT</div>
                    <div class="panel-body">
                        <ul class="menu-list">
                            <li><a href="<?= getLink('account/manage'); ?>">Account Management</a></li>
                            <li><a href="<?= getLink('account/create'); ?>">Create Account</a></li>
                            <li><a href="<?= getLink('account/lost'); ?>">Lost Account?</a></li>
                            <li><a href="<?= getLink('rules'); ?>">Server Rules</a></li>
                            <li><a href="<?= getLink('downloads'); ?>">Downloads</a></li>
                        </ul>
                    </div>
                </div>

                <div class="panel">
                    <div class="panel-header">COMMUNITY</div>
                    <div class="panel-body">
                        <ul class="menu-list">
                            <li><a href="<?= getLink('characters'); ?>">Characters</a></li>
                            <li><a href="<?= getLink('online'); ?>">Who is Online?</a></li>
                            <li><a href="<?= getLink('highscores'); ?>">Highscores</a></li>
                            <li><a href="<?= getLink('houses'); ?>">Houses</a></li>
                            <li><a href="<?= getLink('last-kills'); ?>">Last Kills</a></li>
                            <li><a href="<?= getLink('guilds'); ?>">Guilds</a></li>
                            <li><a href="<?= getLink('support'); ?>">Support List</a></li>
                            <li><a href="<?= getLink('forum'); ?>">Server Forum</a></li>
                        </ul>
                    </div>
                </div>

                <div class="panel">
                    <div class="panel-header">LIBRARY</div>
                    <div class="panel-body">
                        <ul class="menu-list">
                            <li><a href="<?= getLink('ots-info'); ?>">Server Info</a></li>
                            <li><a href="<?= getLink('exp-table'); ?>">Experience Table</a></li>
                        </ul>
                    </div>
                </div>

                <?php if($config['gifts_system']): ?>
                <div class="panel">
                    <div class="panel-header">SHOP</div>
                    <div class="panel-body">
                        <ul class="menu-list">
                            <li><a href="<?= getLink('points'); ?>">Buy Points</a></li>
                            <li><a href="<?= getLink('gifts'); ?>">Shop Offers</a></li>
                            <li><a href="<?= getLink('gifts/history'); ?>">Trans. History</a></li>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Center Column -->
            <div class="center-column">
                <!-- Gameplay Preview Image -->
                <div class="gameplay-preview">
                    <img src="<?php echo $template_path; ?>/images/gameplay-preview.jpg" alt="Gameplay Preview">
                </div>

                <!-- Most Powerful Guilds -->
                <div class="most-powerful-guilds">
                    <h2>Most Powerful Guilds</h2>
                    <div class="guild-list">
                        <?= $guildData; ?>
                    </div>
                </div>

                <!-- News Content -->
                <div class="news-content">
					<?php echo tickers() . template_place_holder('center_top') . $content; ?>
                </div>
            </div>

            <!-- Right Column -->
            <div class="right-column">
                <!-- Login Panel -->
                <div class="panel">
                    <div class="panel-header">LOGIN PANEL</div>
                    <div class="panel-body">
                        <?php if($logged): ?>
                        <div class="logged-user">
                            <p>Welcome, <strong><?php if (USE_ACCOUNT_NAME) echo $account_logged->getName(); else echo 'Account #' . $account_logged->getId(); ?></strong></p>
                            <div class="account-buttons">
                                <a href="<?= getLink('account/manage'); ?>" class="btn btn-primary">MANAGE ACCOUNT</a>
                                <a href="<?= getLink('account/logout'); ?>" class="btn btn-outline">LOGOUT</a>
                            </div>
                        </div>
                        <?php else: ?>
                        <form action="<?= getLink('account/manage'); ?>" method="post">
							<?= csrf(true); ?>
                            <div class="form-group">
                                <input type="text" name="account_login" placeholder="Account name" required>
                            </div>
                            <div class="form-group">
                                <input type="password" name="password_login" placeholder="Password" required>
                            </div>
                            <div class="login-options">
                                <a href="<?= getLink('account/lost'); ?>" class="lost-link">Lost account?</a>
                                <button type="submit" name="Submit" class="login-btn">LOGIN</button>
                            </div>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>

				<?php require __DIR__ . '/totals.php'; ?>
                <!-- Server Statistics -->
                <div class="panel">
                    <div class="panel-header">SERVER STATISTICS</div>
                    <div class="panel-body">
                        <div class="stat-item">
                            <div class="stat-value"><?= $totalAccounts; ?></div>
                            <div class="stat-label">Accounts registered</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?= $totalPlayers; ?></div>
                            <div class="stat-label">Characters created</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?= $totalOnline; ?></div>
                            <div class="stat-label">Players online</div>
                        </div>
                    </div>
                </div>

                <!-- Top Players -->
                <div class="panel">
                    <div class="panel-header">TOP PLAYERS</div>
                    <div class="panel-body">
                        <table class="top-players-table">
                            <?php echo $topData; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="main-footer">
        <div class="footer-nav">
            <a href="<?= getLink('news'); ?>" class="footer-link">Home</a>
            <a href="<?= getLink('account/create'); ?>" class="footer-link">Register</a>
            <a href="<?= getLink('downloads'); ?>" class="footer-link">Download</a>
            <a href="<?= getLink('highscores'); ?>" class="footer-link">Ranking</a>
            <a href="<?= getLink('forum'); ?>" class="footer-link">Forum</a>
        </div>
        <div class="copyright">&copy; <?php echo date('Y'); ?> ServerName. All rights reserved.</div>
    </footer>

    <?php echo template_place_holder('body_end'); ?>
</body>
</html>
