<?php
defined('MYAAC') or die('Direct access not allowed!');

if (!function_exists('mostPowerfulGuildsList') && !function_exists('mostPowerfulGuildsDatabase')) {
    require_once __DIR__ . '/powerful_guilds.php';
}

// Initialize server status
$status = array('online' => true, 'players' => 0);  // Default to online

// Try to detect status
if (function_exists('status_server')) {
    $serverStatus = status_server();
    $status['online'] = $serverStatus['status'];
    $status['players'] = $serverStatus['players'];
} else {
    // Fallback method to check server status
    try {
        if ($db->hasTable('players')) {
            // First try with 'online' column
            try {
                $columns = $db->query("SHOW COLUMNS FROM `players` LIKE 'online'")->fetchAll();
                if (!empty($columns)) {
                    $onlineCount = $db->query('SELECT COUNT(*) FROM `players` WHERE `online` = 1')->fetchColumn();
                    $status['players'] = $onlineCount;
                }
            } catch (Exception $e) {
                // Silent exception - try next method
            }

            // If that didn't work, try with 'is_online' column
            if ($status['players'] == 0) {
                try {
                    $columns = $db->query("SHOW COLUMNS FROM `players` LIKE 'is_online'")->fetchAll();
                    if (!empty($columns)) {
                        $onlineCount = $db->query('SELECT COUNT(*) FROM `players` WHERE `is_online` = 1')->fetchColumn();
                        $status['players'] = $onlineCount;
                    }
                } catch (Exception $e) {
                    // Silent exception
                }
            }
        }
    } catch (Exception $e) {
        // Silent exception - keep default status
    }
}

// Get top players
$topData = '';
$i = 0;
foreach(getTopPlayers(5) as $player) {
    $i++;
    $topData .= '<tr>
                <td>
                    <div class="venore-player-rank">' . $i . '.</div>
                    <span class="venore-player-name">
                        <a href="' . getPlayerLink($player['name'], false) . '">'.$player['name'].'</a>
                        <span class="venore-player-level">' . $player['level'] . ' lvl</span>
                    </span>
                </td>
            </tr>';
}

// Get guild data
$guildData = '';
$guilds = mostPowerfulGuildsList();
if(count($guilds) > 0) {
    $guildCounter = 0;
    foreach($guilds as $guild) {
        $guildCounter++;
        if ($guildCounter > 3) break;

        $guildData .= '<div class="venore-guild-item">
            <div class="venore-guild-emblem guild' . $guildCounter . '"></div>
            <div class="venore-guild-info">
                <div class="venore-guild-name">' . $guildCounter . '. ' . $guild['name'] . '</div>
                <div class="venore-guild-kills">' . $guild['frags'] . ' kills</div>
            </div>
        </div>';
    }
} else {
    $guildData = '<div class="venore-no-guilds">No guilds found.</div>';
}

require __DIR__ . '/totals.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php echo template_place_holder('head_start'); ?>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700;900&family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $template_path; ?>/css/new_style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $template_path; ?>/css/language-selector.css">
    <!-- End CSS -->

    <!-- JS Scripts -->
    <script src="<?php echo $template_path; ?>/js/main.js"></script>
    <script src="<?php echo $template_path; ?>/js/languages.js"></script>

	<script>
		let baseUrl = "<?= BASE_URL; ?>";
	</script>

    <script src="<?php echo $template_path; ?>/js/server_status.js"></script>
    <!-- End JS -->

    <?php echo template_place_holder('head_end'); ?>
</head>
<body>
    <?php echo template_place_holder('body_start'); ?>

    <div class="venore-container">
        <!-- Header -->
        <div class="venore-header">
            <div class="venore-logo">
                <h1><span class="server-name-decoration">ServerName</span></h1>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="venore-nav">
            <a href="<?= getLink('news'); ?>" class="<?php echo (PAGE == 'news') ? 'active' : ''; ?>">News</a>
            <a href="<?= getLink('highscores'); ?>" class="<?php echo (PAGE == 'highscores') ? 'active' : ''; ?>">Highscores</a>
            <a href="<?= getLink('gifts'); ?>" class="<?php echo (PAGE == 'gifts') ? 'active' : ''; ?>">Item Shop</a>
            <a href="<?= getLink('forum'); ?>" class="<?php echo (PAGE == 'forum') ? 'active' : ''; ?>">Forum</a>
            <a href="<?= getLink('downloads'); ?>" class="<?php echo (PAGE == 'downloads') ? 'active' : ''; ?>">Download</a>
        </nav>

        <!-- Main Layout -->
        <div class="venore-layout">
            <!-- Left Sidebar -->
            <div class="venore-sidebar">
                <!-- Account Panel -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Account</div>
                    <div class="venore-panel-body">
                        <ul class="venore-menu-list">
                            <li><a href="<?= getLink('account/create'); ?>" class="<?php echo (PAGE == 'account/create') ? 'active' : ''; ?>">Create Account</a></li>
                            <li><a href="<?= getLink('account/manage'); ?>" class="<?php echo (PAGE == 'account/manage') ? 'active' : ''; ?>">Account Management</a></li>
                            <li><a href="<?= getLink('account/lost'); ?>" class="<?php echo (PAGE == 'account/lost') ? 'active' : ''; ?>">Lost Account</a></li>
                            <li><a href="<?= getLink('rules'); ?>" class="<?php echo (PAGE == 'rules') ? 'active' : ''; ?>">Server Rules</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Community Panel -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Community</div>
                    <div class="venore-panel-body">
                        <ul class="venore-menu-list">
                            <li><a href="<?= getLink('characters'); ?>" class="<?php echo (PAGE == 'characters') ? 'active' : ''; ?>">Characters</a></li>
                            <li><a href="<?= getLink('online'); ?>" class="<?php echo (PAGE == 'online') ? 'active' : ''; ?>">Who is Online</a></li>
                            <li><a href="<?= getLink('highscores'); ?>" class="<?php echo (PAGE == 'highscores') ? 'active' : ''; ?>">Highscores</a></li>
                            <li><a href="<?= getLink('guilds'); ?>" class="<?php echo (PAGE == 'guilds') ? 'active' : ''; ?>">Guilds</a></li>
                            <li><a href="<?= getLink('houses'); ?>" class="<?php echo (PAGE == 'houses') ? 'active' : ''; ?>">Houses</a></li>
                            <li><a href="<?= getLink('last-kills'); ?>" class="<?php echo (PAGE == 'last-kills') ? 'active' : ''; ?>">Last Kills</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Library Panel -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Library</div>
                    <div class="venore-panel-body">
                        <ul class="venore-menu-list">
                            <li><a href="<?= getLink('ots-info'); ?>" class="<?php echo (PAGE == 'ots-info') ? 'active' :	''; ?>">Server Info</a></li>
                            <li><a href="<?= getLink('exp-table'); ?>" class="<?php echo (PAGE == 'exp-table') ?
									'active' : ''; ?>">Experience Table</a></li>
                            <li><a href="<?= getLink('team'); ?>" class="<?php echo (PAGE == 'team') ? 'active' : ''; ?>">Support Team</a></li>
                        </ul>
                    </div>
                </div>

                <?php if($config['gifts_system']): ?>
                <!-- Shop Panel -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Shop</div>
                    <div class="venore-panel-body">
                        <ul class="venore-menu-list">
                            <li><a href="<?= getLink('points'); ?>" class="<?php echo (PAGE == 'points') ? 'active' : ''; ?>">Buy Points</a></li>
                            <li><a href="<?= getLink('gifts'); ?>" class="<?php echo (PAGE == 'gifts') ? 'active' : ''; ?>">Shop Offers</a></li>
                            <li><a href="<?= getLink('gifts/history'); ?>" class="<?php echo (PAGE == 'gifts/history') ? 'active' : ''; ?>">Trans. History</a></li>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Main Content -->
            <div class="venore-content">
                <?php if(PAGE == 'news'): ?>
                <!-- News Content -->
                <h1 class="content-header">Latest News</h1>
                <div class="venore-news">
                    <?php echo tickers() . template_place_holder('center_top') . $content; ?>
                </div>
                <?php else: ?>
                <!-- Regular Content for Other Pages -->
                <div class="venore-page-content">
                    <?php echo tickers() . template_place_holder('center_top') . $content; ?>
                </div>
                <?php endif; ?>
            </div>

            <!-- Right Sidebar -->
            <div class="venore-sidebar">
                <!-- Login Panel -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Login</div>
                    <div class="venore-panel-body">
                        <?php if($logged): ?>
                        <div class="venore-logged-user">
                            <p>Welcome, <strong><?php if (USE_ACCOUNT_NAME) echo $account_logged->getName(); else echo 'Account #' . $account_logged->getId(); ?></strong></p>
                            <div class="venore-account-buttons">
                                <a href="<?= getLink('account/manage'); ?>" class="venore-btn">Manage Account</a>
                                <a href="<?= getLink('account/logout'); ?>" class="venore-btn">Logout</a>
                            </div>
                        </div>
                        <?php else: ?>
                        <form action="<?= getLink('account/manage'); ?>" method="post" class="venore-login-form">
                            <div class="form-group">
                                <input type="text" name="account_login" placeholder="Account name" required>
                            </div>
                            <div class="form-group">
                                <input type="password" name="password_login" placeholder="Password" required>
                            </div>
                            <div class="login-options">
                                <a href="<?= getLink('account/lost'); ?>" class="lost-link">Lost account?</a>
                                <button type="submit" name="Submit" class="venore-btn">Login</button>
                            </div>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Server Statistics -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Statistics</div>
                    <div class="venore-panel-body">
                        <div class="venore-stat-item">
                            <div class="venore-stat-value"><?php echo number_format($totalAccounts); ?></div>
                            <div class="venore-stat-label">Accounts registered</div>
                        </div>
                        <div class="venore-stat-item">
                            <div class="venore-stat-value"><?php echo number_format($totalPlayers); ?></div>
                            <div class="venore-stat-label">Characters created</div>
                        </div>
                        <div class="venore-stat-item">
                            <div class="venore-stat-value"><?php echo number_format($totalOnline); ?></div>
                            <div class="venore-stat-label">Players online</div>
                        </div>
                    </div>
                </div>

                <!-- Top Players -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Top Players</div>
                    <div class="venore-panel-body">
                        <div class="venore-rankings">
                            <table>
                            <?php echo $topData; ?>
                        </table>
                            <div style="text-align: center; margin-top: 15px;">
                                <a href="<?= getLink('highscores'); ?>" class="venore-btn">Full Rankings</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Download Button -->
                <div class="venore-panel">
                    <div class="venore-panel-header">Client</div>
                    <div class="venore-panel-body" style="text-align:center;">
                        <a href="<?= getLink('downloads'); ?>" class="venore-btn">Download Game</a>
                    </div>
                </div>
            </div>
        </div>

    <!-- Footer -->
        <footer class="venore-footer">
            <div class="venore-social">
                <a href="#"><i class="fab fa-discord"></i></a>
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-youtube"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
            <div class="venore-copyright">
                &copy; 2025 ServerName. All rights reserved.
            </div>
            <!-- This credit line is required and cannot be removed -->
            <div class="designer-credit" data-protect="true" onclick="event.preventDefault();">
                Designed By Saad
            </div>
            <script>
            // Script to prevent modification of the designer credit
            document.addEventListener('DOMContentLoaded', function() {
                const protectCredit = function() {
                    const credit = document.querySelector('.designer-credit');
                    if (!credit || credit.innerText !== 'Designed By Saad') {
                        location.reload();
                    }
                };

                // Check periodically
                setInterval(protectCredit, 2000);

                // Also protect from DOM modification
                const observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.target.classList.contains('designer-credit') ||
                            mutation.target.closest('.designer-credit')) {
                            protectCredit();
                        }
                    });
                });

                observer.observe(document.body, {
                    childList: true,
                    attributes: true,
                    characterData: true,
                    subtree: true
                });
            });
            </script>
        </footer>
        </div>

    <?php echo template_place_holder('body_end'); ?>
</body>
</html>
