<?php
defined('MYAAC') or die('Direct access not allowed!');

// Get server statistics
$totalAccounts = 0;
$totalPlayers = 0;
$totalOnline = 0;

if ($db->hasTable('accounts')) {
	$totalAccounts = $db->query('SELECT COUNT(*) FROM `accounts`')->fetchColumn();
}

if ($db->hasTable('players')) {
	$totalPlayers = $db->query('SELECT COUNT(*) FROM `players`')->fetchColumn();

	// Check which online status column exists in the database
	$columns = $db->query("SHOW COLUMNS FROM `players` LIKE 'online'")->fetchAll();
	if (!empty($columns)) {
		$totalOnline = $db->query('SELECT COUNT(*) FROM `players` WHERE `online` = 1')->fetchColumn();
	} else {
		// Try alternative column names that might be used for online status
		$columns = $db->query("SHOW COLUMNS FROM `players` LIKE 'is_online'")->fetchAll();
		if (!empty($columns)) {
			$totalOnline = $db->query('SELECT COUNT(*) FROM `players` WHERE `is_online` = 1')->fetchColumn();
		} else {
			// If no online column exists, default to 0
			$totalOnline = 0;
		}
	}
}
